#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//crazy stupid fractalMod01.fsh   by  pflowsoftware   
//https://www.shadertoy.com/view/ltXGWn
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Julia Set for (.285,.01)
#define CREAL .268
#define CIMAG .060
#define DEPTH 1000
#define R x
#define I y

vec3 hsv(float h,float s,float v) {
	return mix(vec3(1.),clamp((abs(fract(h+vec3(3.,2.,1.)/3.)*6.-3.)-1.),0.,1.),s)*v;
}

float cMag2(vec2 c){
    return c.R*c.R+c.I*c.I;
}
float cArg(vec2 c){
 	return atan(c.I,c.R);   
}
float cMag(vec2 c){
 	return sqrt(c.R*c.R+c.I*c.I);   
}
vec2 cLog(vec2 c){
 	float real = log(cMag(c));
    float imag = cArg(c);
    return vec2(real,imag);
}
vec2 cConj(vec2 c){
	return vec2(c.R, -1.*c.I);   
}
vec2 cMult(vec2 c1, vec2 c2){
    float real = c1.R*c2.R-c1.I*c2.I; //real * real - imag * imag
    float imag = c1.R*c2.I+c1.I*c2.R; //real * imag + imag * real
    return vec2(real,imag);
}
vec2 cDivScalar(vec2 c, float s){
    return vec2(c.R/s,c.I/s);
}
vec2 cDiv(vec2 c1, vec2 c2){
	vec2 c2c = cConj(c2);
    vec2 numerator = cMult(c1,c2c);
    float denominator = cMult(c2,c2c).R;
    return cDivScalar(numerator,denominator);
}
vec2 cSum(vec2 c1,vec2 c2){
    return vec2(c1.R+c2.R,c1.I+c2.I);}

vec2 cSqr(vec2 c){
    return vec2(c.R*c.R-c.I*c.I,2.*c.R*c.I);}

float julia(vec2 z, vec2 C){
    float attSize = 0.; //.01*(sin(iTime/10.));
    float iteration = 0.;
    for( int i = 0; i < 10; i++){
        
        z = cSum(cDiv(cSum(cSqr(z),z),cLog(z)),C);
        
        //if (cMag2(z)>4.){return float(DEPTH-i)/float(DEPTH);} //escape
        //if (cMag2(z)<attSize){return 1.;} //creates Attractors (Spots)
        iteration += 1.;
        if (cMag2(z) > 16. || iteration>=float(DEPTH)){break;}
    }
    if ( iteration < float(DEPTH) ) {
        float zn = cMag(z);
        float nu = log( log(zn) / log(2.) ) / log(2.);
        // Rearranging the potential function.
        // Could remove the sqrt and multiply log(zn) by 1/2, but less clear.
        // Dividing log(zn) by log(2) instead of log(N = 1<<8)
        // because we want the entire palette to range from the
        // center to radius 2, NOT our bailout radius.
        iteration = iteration + 1. - nu;
  	}
    return float(iteration);
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   
    mat2 rot;
    float zoom = 1.; //1.2*abs(sin(iTime/8.));
	
	float deg = iTime/4.+sin(iTime/4.);;
	
	rot[0] = vec2(cos(deg), sin(deg));
	rot[1] = vec2(-sin(deg), cos(deg));
    
    float aspectRatio = iResolution.x/iResolution.y;
    float xMod = (fragCoord.x / iResolution.x - .5)*3.0*aspectRatio;
    float yMod = (fragCoord.y / iResolution.y - .5)*3.0;
    vec2 z = vec2(xMod,yMod)*rot*zoom;
	
    //float realSeed = .285+1.*tan(iTime/tan(iTime/2000.)); //curly + stringy
    float realSeed = CREAL+.01*tan(iTime/2.)+.01*sin(iTime/2.);
    //float realSeed = CREAL;
    //float imagSeed = CIMAG;
    float imagSeed = CIMAG +.01*sin(iTime/3.0);
    vec2 C = vec2(realSeed,imagSeed);
    //vec2 C = vec2(0,0);
	float x = julia(z,C);
	fragColor = vec4(hsv(1.*x+sin(iTime/10.), 1., .2+x), 1.0);   
//hsv from gleurop "The Pulse", thanks
//rot from sander "Texture spin & zoom", thanks
    

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

